'******************************************************************************
' HTTP declarations
'******************************************************************************
'*******************************************************************************
'  Pollin NET-IO Board with Atmega32 / 644 / 644P and ENC28J60
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'

'*******************************************************************************
$nocompile


   Const Cr_lf = "{013}{010}"
   ' Lebenszeit des Segment, bevor eine Retransmission erfolgt
   ' nach drei Versuchen ist dann aber Schlu!
   ' Wert in Sekunden + 1
   Const Http_lifetime_seconds = 4

' *** HTTP STACK ***
#if _chip = 23
   Const Http_max_ports = 3                                 'maximale Anzahl geffneter Verbindungen
#else
   Const Http_max_ports = 8                                 'maximale Anzahl geffneter Verbindungen
#endif

#if Netio_mode = 1
   Dim Switch_port As String * 1
   Dim Switch_value As String * 1
   Dim Commandmodem32 As Byte
#endif
#if Netio_mode = 1 Or Include_svg = 1
   Dim Ack_pointer As Byte
#endif
   Dim Fifo(http_max_ports) As Byte
   Dim Fifo_tmp(http_max_ports) As Byte

   Dim Http_stack_flag As Byte

   ' Wir bentigen ALLE! Parameter des IP und TCP Header,
   ' um den HEADER fr den Versand zu erstellen
   ' leider gibt es keine mehrdimensionale Array's,
   ' sonst htte man 54 Byte pro Eintrag gecacht!That's life :-)
   ' also machen wir es zu Fu....

   Dim Http_stack_fin(http_max_ports) As Byte
   Dim Http_stack_retry(http_max_ports) As Byte

   Dim Http_stack_type(http_max_ports) As Byte
   Dim Http_stack_filename(http_max_ports) As String * 12

   ' *** ETH Part ***
   ' 0-5    DST MAC  we have it, it's ower own MAC!
   ' 6-11   SRC Mac address
   Dim Http_stack_mac0(http_max_ports) As Byte
   Dim Http_stack_mac1(http_max_ports) As Byte
   Dim Http_stack_mac2(http_max_ports) As Byte
   Dim Http_stack_mac3(http_max_ports) As Byte
   Dim Http_stack_mac4(http_max_ports) As Byte
   Dim Http_stack_mac5(http_max_ports) As Byte
   ' 12-13  Typ 0x8000

   ' *** IP Part ***
   ' Byte
   ' 14     Version = 0x45 (69)
   ' 15     IHL=0 differntiated Service Field
   ' 16-17  Length IP-Header, TCP-Header and Payload
   Dim Http_stack_headerlength(http_max_ports) As Word
   ' 18-19  Identification, will be incr by 1! fragmented Segmentes!!!
   Dim Http_stack_fragment(http_max_ports) As Word
   ' 20-21  always 0x40 0x00
   ' 22    Time to live (128)
   Dim Http_stack_lifetime(http_max_ports) As Byte
   ' 23    TCP Protokoll 0x06
   ' 24-25 IP-Header Checksum
   ' 26-29 IP Source Address
   Dim Http_stack_ipsrc(http_max_ports) As Long
   ' 30-33 IP Destination Address
   Dim Http_stack_ipdest(http_max_ports) As Long

   ' *** TCP Part ***
   ' 34-35 Source Port
   Dim Http_stack_port_src(http_max_ports) As Word
   ' 36-37 Destination Port
   Dim Http_stack_port_dest(http_max_ports) As Word
   ' 38-41 Sequnce number
   Dim Http_stack_seqnum(http_max_ports) As Long
   ' 42-45 Acknowledge number
   Dim Http_stack_acknum(http_max_ports) As Long
   ' 46    Header Length  should be always 20 Byte!
   ' 47    TCP Flags
   ' 48-49 Window Size
   ' 50-51 TCP Checksum
   ' 52-53 0x0000

   ' hier werden die ACK zu gesndeten Paketen vermerkt.
   ' wenn nach Abschluss des Senden, der ACk Pointer differiert, muss nachgesendt werden
'   Dim Http_stack_sliding(http_max_ports) As Long


   Dim Http_z_index As Word

   Declare Sub Http
   Declare Sub Http_paket_senden
   Declare Sub Http_syncronisation
   Declare Sub Ack_auf_fin_senden
   Declare Sub Http_process_fifo_entry
   Declare Sub Paket_senden
   Declare Sub Rotate_fifo
#if Debug_http > 2
   Declare Sub Http_dump_stack(byval Art As String , Byval Entry As Byte)
#endif
   Declare Sub Reset_stack_entry(byval Nr As Byte)
   Declare Sub Set_ip_header_len(byval Headerlen As Word)
'#if Netio_mode = 0
   Declare Sub Http_stack_life
'#endif
   Declare Sub Http_anfrage

   Declare Function Append_to_dataload(byref Dataload_pointer As Word , Byval S_s As String ) As Word
#if Include_javascript = 1
   Declare Function Javascript(byval Stack_entry As Byte , Byref Http_ack_pointer As Long , Byref Dataload_pointer As Word) As Byte
   Declare Sub Fs_js_string(byval I As Integer , Byval J As Integer, Byref Dataload_pointer As Word)
#endif
#if Include_ajax = 1
   Declare Function Ajax(byval Stack_entry As Byte , Byref Dataload_pointer As Word) As Word
#endif
#if Include_svg = 1
   Declare Function Svg(byval Stack_entry As Byte , Byref Http_ack_pointer As Long , Byref Dataload_pointer As Word) As Byte
   Declare Function Svg_header(byref Dataload_pointer As Word , Byval Width As Word , Byval Height As Word) As Word
   Declare Sub Svg_line(byval X1 As Word , Byval Y1 As Word , Byval X2 As Word , Byval Y2 As Word , Byval Width As Byte , Byval Red As Byte , Byval Green As Byte , Byval Blue As Byte , Byref Dataload_pointer As Word)
   Declare Sub Svg_begin_path(byval X1 As Word , Byval Y1 As Word , Byref Dataload_pointer As Word)
   Declare Sub Svg_end_path(byval Width As Byte , Byval Red As Byte , Byval Green As Byte , Byval Blue As Byte , Byref Dataload_pointer As Word)
#endif
   Declare Function Get_header(byval Stack_entry As Byte , Byref Dataload_pointer As Word) As Word
   Declare Function Ip_to_string(byval Ip As Long) As String
   Declare Function Http_find_stack_position(byval Tcp_port As Word) As Byte
   Declare Function Proccess_fifo_stack_entry(byref Http_stack_position As Byte) As Byte
   Declare Sub Tcp_ip_header(byval Tempx As Byte)
#if Debug_http > 2
   Declare Sub Dump_tcp_ip
#endif
   Declare Sub Http_reset(byref Lb As Byte)


#if Debug_http = 1
   Declare Sub Http_debug_flags
#endif

#if Netio_mode = 1 Or Netio_mode = 90
   Declare Function Http_m32_content(byref Datei As String , Byref Http_ack_pointer As Long , Byref Dataload_pointer As Word) As Byte
#else
  #if Include_sdcard = 0
   'Rckgabewert = gelesene Bytes
   Declare Function Http_read_file_from_flash(byref Datei As String , Byref Http_ack_pointer As Long , Byref Dataload_pointer As Word) As Byte
  #endif

  #if Include_sdcard = 1
   'Rckgabewert = gelesene Bytes
   Declare Function Http_read_file_from_sdcard(byref Datei As String , Byref Http_ack_pointer As Long , Byref Dataload_pointer As Word) As Byte
  #endif
#endif

   ' initialize
'   For Http_index = 1 To Http_max_ports
'       Call Reset_stack_entry(http_index)
'   Next